---
Note type: Reference
tags:
  - "#REFERENCE"
Reference type: Book
Bib_ref: "Wright, Christopher and Nyberg, Daniel (2015) Climate Change, Capitalism, and Corporations: Processes of Creative Self-Destruction. Cambridge: Cambridge University Press."
Title: "Climate Change, Capitalism, and Corporations: Processes of Creative Self-Destruction"
Authors: Christopher Wright, Daniel Nyberg
Year: 2015
Journal-publisher: Cambridge University Press
Read: In progress
Related areas:
  - "[[Research]]"
Related projects:
  - "[[Paper Y]]"
Related tasks: 
Related references: 
Related zettels:
  - "[[degrowth]]"
  - "[[Sustainability]]"
  - "[[limits to growth]]"
  - "[[environmental discourses]]"
Related meeting notes: 
Related resources: 
Related people:
  - "[[Christopher Wright]]"
  - "[[Daniel Nyberg]]"
  - "[[Karl Marx]]"
  - "[[Joseph Schumpeter]]"
  - "[[Christopher Wright]]"
  - "[[Daniel Nyberg]]"
  - "[[Karl Polanyi]]"
aliases: 
Creation date: 2024-05-27
Last modified: 2024-05-27
---
## Fleeting notes

Only read chapters 1, 2 and 8 so far
## Overview

### Context

### RQ

### Thesis

“We are destroying ourselves. It is as simple as that. Economic growth and the exploitation of nature have long gone hand-in-hand, but they now constitute the most ill-fated of bedfellows. Climate change, the greatest threat of our time, is the definitive manifestation of the well-worn links between progress and devastation. And as we continue to shamble towards a tipping point from which any meaningful return will be utterly impossible, a familiar message rings out from the corporate world: ‘**business** **as** **usual**’.” ([[Wright and Nyberg 2015]], p. 1)

“This book is about that message. It is about the corporate world’s relationship with climate change; it is about the terrible paradox at the heart of that relationship; and it is about how that relationship affects us all. It is about how such a message could come to be accepted in the face of the steady annihilation of our planet; it is about how we might recognise it for what it is – the most dangerous of fallacies – and replace it with something more in keeping with our increasingly desperate plight.” ([[Wright and Nyberg 2015]], p. 2)

“In this book we argue that the corporate world’s engagement with climate change represents a profound influence on humanity’s actions  – and, more significantly, its inactions – in responding to the fast-unfolding crisis.” ([[Wright and Nyberg 2015]], p. 3)

“climate change has revealed one of the fundamental contradictions of capitalism:  the necessity to consume the natural environment to ensure continued economic growth.” ([[Wright and Nyberg 2015]], p. 25)

“We contend that the particular neoliberal variant of late capitalism that now dominates the global economy places humanity at a strategic disadvantage in responding to the threat of climate change. This brand of corporate capitalism frames business and markets as the only means of dealing with the crisis, rejecting the need for state regulation and more local democratic options.” ([[Wright and Nyberg 2015]], p. 4)

“we believe the solution lies not in greater capitalism but in a strengthening of the very **democracy** that this strain of corporate hegemony seems determined to herd to the margins.” ([[Wright and Nyberg 2015]], p. 4)

### Methodology

“our focus is explicitly on the role of corporations as central players in the human response to climate change.” ([[Wright and Nyberg 2015]], p. 5)

“our analysis is based on extensive research into the practices, policies, and strategies of major businesses.” ([[Wright and Nyberg 2015]], p. 5)

“Our research involved interviews with more than 70 senior managers, industry representatives, and business advisers from 25 different large corporations in Australia (see Appendix Table A.1), as well as analysis of company documentation, including strategy outlines, policy statements, and submissions to government on climate policy.” ([[Wright and Nyberg 2015]], p. 5)

“From our initial sample we selected five corporations as case studies.” ([[Wright and Nyberg 2015]], p. 5)
- “A leading energy producer that was supplementing fossil fuel generation with renewable energy sources”
- “A large insurer that was measuring the financial risks of extreme weather events”
- “A major financial services company that was factoring a ‘price on carbon’ into its lending to corporate clients” “A global manufacturer that was reinventing itself as a ‘green’ company producing more efficient industrial equipment and renewable energy technologies”
- “A media company that had embarked on a major eco-efficiency drive to become ‘carbon-neutral’” ([[Wright and Nyberg 2015]], p. 5)

### Theoretical approach

“**critical social theory**” : debates about “how and why humanity has been largely unable to muster a meaningful response to the crisis that is engulfing it.” ([[Wright and Nyberg 2015]], p. 6)
- “we aim to explain the **processes** that underpin how business corporations engage employees, customers, industry associations, the media, governments, and citizens on this issue.” ([[Wright and Nyberg 2015]], p. 6)
- “we seek to go beyond existing descriptive and normative approaches to develop a more sociologically and critically informed **theory of corporate responses** to climate change.” ([[Wright and Nyberg 2015]], p. 6)

“Many have posited that climate change represents an especially ‘**wicked** **problem**’ because of its scale, its lack of immediacy, and its intangibility (Giddens, 2009; Hulme, 2009), but we suggest there are more deep-rooted reasons for our collective inaction and that these stem from the basic features of our economic system.” ([[Wright and Nyberg 2015]], p. 6)

Draws from:
- [[ecological sociology]]
- “treadmill of production perspective” ([[Wright and Nyberg 2015]], p. 25)

### Findings

### Contributions

### Striking points

### Further research suggested

### My ideas/responses

### Useful references

### Structure

- Chapter 2: “the political and economic response to climate change highlights a form of ‘**creative** **self-destruction**’ in which businesses are encouraged to further devour the very life-support systems of a habitable environment.” ([[Wright and Nyberg 2015]], p. 25)
	 - “We suggest that this entirely irrational path is made ‘sensible’ through **incorporation of critique**, in which criticism of corporate activities is absorbed and adapted to further justify capitalist expansion.” ([[Wright and Nyberg 2015]], p. 25)
- Chapter 3: “corporations have constructed climate change as a space of **business risk and opportunity.**” ([[Wright and Nyberg 2015]], p. 25)
	 - “We view **risk as socially constructed;** in other words, we suggest that corporations, by identifying, measuring, and assessing risk, are taking part in constructing the very phenomenon to which they are responding” ([[Wright and Nyberg 2015]], p. 25)
	 - “We argue that the construction of climate change as risk legitimises and justifies particular corporate activities and practices; moreover, we argue that the framing of societal events as risks is also a political act, since the construction of risk closes certain paths and opens others in addressing the perceived threat.” ([[Wright and Nyberg 2015]], p. 25)
- Chapter 4: “corporations influence the **political** debate and further their objectives by building coalitions with like-minded enterprises, industry groups, the media, think tanks, NGOs and by the promotion of social movements.” ([[Wright and Nyberg 2015]], p. 25)
- Chapter 5: “We explore the process of **compromise** in corporate engagements with climate change and how multiple competing justifications for corporate action are internally resolved” ([[Wright and Nyberg 2015]], p. 26)
	 - “we explain how the dispute between profit and the environment is conveniently and habitually settled through compromise. We argue that this involves the **commensuration** of competing ‘orders of worth’, which leads to the corruption of the environment by **converting it into a market commodity**.” ([[Wright and Nyberg 2015]], p. 26)
- Chapter 6: “focus on the emergent occupational community of **sustainability managers** and advisers.” ([[Wright and Nyberg 2015]], p. 26)
- Chapter 7: “how corporations have sought to define appropriate **emotional** **responses** to the climate crisis.” ([[Wright and Nyberg 2015]], p. 26)
- Chapter 8: “the role of **political** **myths** in creating a convincing narrative of humanity’s response to climate change.” ([[Wright and Nyberg 2015]], p. 27)
- Chapter 9: “six movements that can promote people’s **imaginations** in demanding a change to our current path.” ([[Wright and Nyberg 2015]], p. 27)
	 - “questioning how we see our relationship to nature”
	 - “disrupting the language of climate change”
	 - “promoting greater democracy in climate politics”
	 - “emphasising the worth of environment beyond a market commodity”
	 - “developing a green identity beyond consumption”
	 - “championing the positive emotionality of climate action.”

## Chapter 1: Climate change and corporate capitalism

[[alignment of action and intention]]: “Tangible political action remains limited to rhetorical flourishes against a background of even greater fossil fuel exploitation. While governments and international organisations pledge reductions in greenhouse gas (GHG) emissions and businesses promote ‘sustainability’, global emissions have increased to record levels. Despite heightened political awareness of the problem of anthropogenic climate change, as outlined in Figure 1.1, total GHG emissions have continued to grow and indeed the rate of growth has accelerated in recent years (Global Carbon Project, 2014). There is plainly a substantial disconnect between how we value our socio-economic activities and how we regard what the established body of climate science is telling us (IPCC, 2013; Melillo et al., 2014).” ([[Wright and Nyberg 2015]], p. 3)

“**Business plays a dual role in climate politics**. On the one hand, corporations are the principal agents in the production of GHG emissions in the global economy; on the other hand, they are also seen as our best hope in reducing emissions through technological innovation. Just as they are part of the **disease**, we dream corporations will be part of the **cure**.” ([[Wright and Nyberg 2015]], p. 4)

“national and regional conflicts over climate change have played out over the past two decades at various UN Climate Change Conferences.” ([[Wright and Nyberg 2015]], p. 9)
- “an alleged high watermark in global climate negotiations: the so-called **Kyoto Protocol,** which resulted from the **1997** UN Conference on Climate Change and committed wealthy, developed economies to undertake significant emissions cuts. Domestic political gridlock meant the United States failed to ratify the agreement – largely on the pretence that it excluded developing countries (Clark and Berners-Lee, 2013) – thereby handing other developed economies an excuse to avoid taking strong action.” ([[Wright and Nyberg 2015]], p. 10)
- “In the wake of the fourth IPCC report, which was published in 2007 and warned of the serious harm to ecosystems and societies that would result from continued GHG emissions, hopes that the **2009 Copenhagen climate talks** would lead to a meaningful international agreement were high. This optimism proved sadly misplaced. The resurfacing of national and regional tensions undermined any multilateral agreement. The so-called BRICS nations of Brazil, Russia, India, China, and South Africa emerged as key players in climate negotiations, staunchly emphasising their national economic interests, while the United States, once again hamstrung by domestic political division, failed to offer leadership” ([[Wright and Nyberg 2015]], p. 10)
 - “The Copenhagen talks were also mired in the confected conspiracy of the so-called Climategate scandal, which questioned the veracity of climate science and emboldened a resurgent denial campaign (Mann, 2012)” ([[Wright and Nyberg 2015]], p. 11)

“The twentieth century saw the rise of ‘**corporate** **capitalism**’; the twenty-first century has witnessed its further expansion under the spread of neoliberalism (Harvey, 2007).”
- “Business corporations represent around 40 per cent of the world’s largest economic entities, their revenues dwarfing many national economies.” ([[Wright and Nyberg 2015]], p. 14)
- “Fossil-fuel-based energy giants dominate the roll-call of mega-corporations, with the revenues of the five largest – Royal Dutch Shell, ExxonMobil, BP, Sinopec, and China National Petroleum – equivalent to 3 per cent of global gross domestic product (GDP).” ([[Wright and Nyberg 2015]], p. 14)
- “Although it is often assumed that GHG emissions are largely dispersed across economic sectors, recent research has shown how a relatively small number of business entities have contributed to the majority of global emissions over time.” ([[Wright and Nyberg 2015]], p. 15)

**GHG [[rebound effects]]**: “critics note the way in which corporate ‘greening’ strategies by promoting greater efficiency and cost reduction can actually result in overall increases in GHG emissions through increasing demand for their products (Owen, 2011).” ([[Wright and Nyberg 2015]], p. 17)

**Difficulty of decoupling economic production and environmental damage:** “This paradox underpins the problem of ‘decoupling’ economic production from its material effects which has proved elusive in both relative and absolute terms (Jackson, 2009).” ([[Wright and Nyberg 2015]], p. 22) - [[degrowth]]

## Chapter 2: Creative self-destruction and the incorporation of critique

### Context

- The Stern Review (2006) declared “Business as usual’ not an option and yet argued for “Policies to support new technologies” such as “‘Carbon pricing’ and ‘carbon finance’” ([[Wright and Nyberg 2015]], p. 28) ([](https://en.wikipedia.org/wiki/Stern_Review)[https://en.wikipedia.org/wiki/Stern_Review](https://en.wikipedia.org/wiki/Stern_Review) )
- “characterised climate change as a **market failure,** proposing the pricing of carbon emissions (defined as [[externalities]]) and the discipline of the market mechanism as a solution: in other words, the market should correct itself.” ([[Wright and Nyberg 2015]], p. 30)
- This “captures the very essence of **creative self-destruction**: it encapsulates the bizarre notion that the only available response to a problem caused by the market’s ever-expanding reach is to expand that reach further still.” ([[Wright and Nyberg 2015]], p. 28)
- “Businesses have argued that the cure for the environmental ills within corporate capitalism is more corporate capitalism and that the problem, as if by magic, is therefore actually the solution.” ([[Wright and Nyberg 2015]], p. 29)

### Thesis

“We argue that it is the enduring promulgation of such a belief – the insidious spread and entrenchment of the idea that only more consumption can remedy the devastating consequences of over consumption – that allows inventive genius to go hand-in-hand with selective blindness, capitalism to freeride on nature and the environment itself to be rendered nothing more than a commodity.” ([[Wright and Nyberg 2015]], p. 28)
- “We contend that a central reason for the lack of political and economic engagement on climate change is the uncomfortable way in which this issue **reveals the underlying paradox of capitalism** as an economic system that relies on the destruction of nature for its own development.” ([[Wright and Nyberg 2015]], p. 29)

### The ‘treadmill of production’ perspective - [[capitalism’s crisis tendency]]

- “comes from the fields of [[environmental sociology]] and [[political economy]]” ([[Wright and Nyberg 2015]], p. 31)
- “harks back to [[Karl Marx|Marx]]’s original observation that capitalism is an economic system that depends on the unending exploitation of nature (Foster, 2000).” ([[Wright and Nyberg 2015]], p. 31)
- “posits that there is a basic conflict between the political economy of global capitalism and environmental well-being; that capital investment leads to ever-growing demand for natural resources if employment and consumption are to be maintained; and that resource extraction results in the further commodification of nature through increasing profits and new investment, thus setting in train even more demand for natural resources” ([[Wright and Nyberg 2015]], p. 31)
- “As Harvey (2014: 154) remarks, capitalism never truly solves the crises it generates: rather, ‘it moves them around’.” ([[Wright and Nyberg 2015]], p. 34)
- **Resistance to challenge:**
	 - “strengthens ‘the economic and political **power of shareholders** (investors and managers)’ who frame any resistance to ecological destruction as ‘antediluvian, Luddite, old-fashioned, reactionary and doomed to failure’ (Gould et al., 2004: 297).” ([[Wright and Nyberg 2015]], p. 31)
	 - “Opposition is further limited by the reliance of citizens and workers on employment and wages and by the distribution of the worst pollution and degradation to poorer, remote locations or to ‘**sacrifice** **zones**’ (Klein, 2014: 173),” ([[Wright and Nyberg 2015]], p. 31)
- “In contrast to the progressive view of ecological modernisation, the ‘treadmill of production’ argument claims that environmental destruction is less an unfortunate by-product of industrialisation and more an **essential feature** of our economic system.” ([[Wright and Nyberg 2015]], p. 31)

### Creative self-destruction - [[capitalism’s crisis tendency]]

- “builds on the broader depiction of **capitalism** as an economic system based on **crises** and the ‘enforced destruction of a mass of productive forces’ (**Marx** and **Engels**, [1848] 1998: 42).” ([[Wright and Nyberg 2015]], p. 32)
- “[[Joseph Schumpeter]] (1942) famously characterised this process as one of ‘**[creative destruction](https://www.notion.so/creative-destruction-a8fd63dd4ed84092b4732fbdcc56522b)**’ in which technological innovation and entrepreneurship not only created waves of innovation but also swept away previous forms of capital accumulation and natural resources.” ([[Wright and Nyberg 2015]], p. 32)
- **Schumpeter** highlighted the **systemic risks** associated with creative destruction: ‘In breaking down the pre-capitalist framework of society, capitalism thus broke not only barriers that impeded its progress but also flying buttresses that prevented its collapse ... [T]he capitalist process, in much the same way in which it destroyed the institutional framework of feudal society, also undermines its own’ (Schumpeter, 1942: 139). ([[Wright and Nyberg 2015]], p. 32)
- “However, **unlike Marx** and many Marxist scholars (see, e.g., Harvey, 2014; O’Connor, 1988), **we do not see this crisis as stemming from contradictions internal to the capitalist economy**. In this instance contradiction results from the endless accumulation and consumption of the basis for the capitalist system itself: **nature**.” ([[Wright and Nyberg 2015]], p. 33)
- “**capitalism** is basically **free-riding** **on** **nature**, both as a source of ‘inputs’ to production and as a ‘sink’ to absorb capitalism’s waste (Fraser, 2014: 63). Further, nature’s CO2 sinks are rapidly cut down and denuded for capitalist production. This is why capitalism as an economic model and social order cannot incorporate the environment. **Totalising the environment**, broadly speaking, would create a closed system and necessarily a **collapse**.” ([[Wright and Nyberg 2015]], p. 33)
 - _This is a very different way of thinking about capitalism’s externalities - whereas Stern argues these effects must be internalized into the economy, Wright and Nyberg suggest that such internalization would destroy the natural basis of the economy_
 - Capitalism is internalizing carbon through carbon markets, but not biodiversity: “It is the essential politics of capitalism to ‘manage’ the boundary in terms of what should be included (e.g., humans, carbon) and excluded (e.g., other species). While the boundary can be expanded to include, say, the circulation of capital through carbon markets or geoengineering, capitalism requires the destruction of the outside to support the inside.” ([[Wright and Nyberg 2015]], p. 34)
- “At the core of this absolute contradiction is capitalism’s dependence on **compound economic growth**. As Harvey (2014) argues, if the economy is not continuously expanding then it is no longer a capitalist system.” ([[Wright and Nyberg 2015]], p. 34)

## Chapter 8: Political myths and pathways forward

**RQ**: “In this chapter we ponder **why the response to the climate crisis has been so limited**.”

**Thesis**: “We suggest that **three political myths** have been central to the maintenance of the prevailing ‘business as usual’ ethos and the obfuscation of the nightmare whose unfolding has been obvious for the better part of 40 years.” ([[Wright & Nyberg 2015]], p. 165)
- “**myths** are common narratives that address the particular political conditions or criticisms facing a society by answering ‘a need for significance’ (Bottici, 2007: 133 and 136). They assist in coping with complicated problems by reducing complexity and acting as sense-making devices.” ([[Wright & Nyberg 2015]], p. 166)
- “These **myths** work as blinders. They **limit our imagination**, preventing us from seeing not just where we are heading but the roads we have neglected to take.” ([[Wright & Nyberg 2015]], p. 166)
- Myths underpin broader [[imaginary|imaginaries]]

### “The myth of [[corporate environmentalism]]”

- “presents corporations as active participants in the mitigation of environmental damage.” ([[Wright & Nyberg 2015]], p. 166)
- “it advances the notion that economic growth and environmental well-being are mutually supportive – in essence, that corporations can ‘**do well by doing good**’ {…} and that **external interference is therefore unnecessary**.”
- The myth is palpable in:
	 - **corporate practices**
	 - eco-efficiency
	 - waste reduction
	 - recycling
	 - ‘green’ branding
	 - environmental reporting
	 - adoption of more ‘sustainable’ approaches
	 - “new standards of **voluntary reporting** (e.g., the Carbon Disclosure Project, the Dow Jones Sustainability Index, and the Global Reporting Initiative)”
	 - “more **investor focus** on companies’ environmental performance”
	 - “the creation of **specialist sustainability functions** within major firms”
- “Corporate environmentalism narrows the cognitive dissonance between our concerns and our conduct. By suggesting that individual choices are the solution to a collective problem (Hamilton, 2010), it squares our fears over climate change with our contributions to GHG emissions.” ([[Wright & Nyberg 2015]], p. 168)

### “The myth of [[corporate citizenship]]”

- “the myth of corporate citizenship equips businesses with a **recognised and moral role** in addressing the issue {of climate change}” ([[Wright & Nyberg 2015]], p. 168)
- “corporations increasingly present themselves as the key civil actors **best placed to shape political agendas and satisfy social and environmental needs**.” ([[Wright & Nyberg 2015]], p. 169)
- “The **personification** of businesses as moral citizens committed to the betterment of civil society not only neatly obscures executives’ fiduciary obligation to serve their shareholders above all others: it has come to be seen as the natural state of affairs.” ([[Wright & Nyberg 2015]], p. 169)
- Includes:
	 - “espousing of self-serving legislation”
	 - “intrusion into and ‘capture’ of regulatory agencies”
	 - “the privatisation of governmental functions across all levels of society.” ([[Wright & Nyberg 2015]], p. 169)
- “‘The people’ are afforded **political** **recognition** **and** **a voice** – even without speaking – via **consumption**, which itself is granted a political identity. This is how **citizenship itself is subverted** and relegated to a surrogate for profit and shareholder value” ([[Wright & Nyberg 2015]], p. 170)
 - “the result is a rising **imbalance in political power** between corporations and other groups and a **decline in democracy** as businesses’ ability to influence legislative and social outcomes intensifies.” ([[Wright & Nyberg 2015]], p. 170)

### “The myth of corporate omnipotence” - [[technocracy]]

- Presents corporate capitalism as technologically **determined**
- Presents “corporate capitalism as an ineluctable and **superior** form of economic organisation – one founded on managerial tools and practices that are not only commendably **rational** but also highly **effectual** – and as the sole, supremely **inevitable** rejoinder to the climate crisis both now and in the future.” ([[Wright & Nyberg 2015]], p. 170)
- “At the very heart of the myth of corporate omnipotence is the **claim that the rational expertise businesses have at their disposal is somehow capable of taming nature**. The direct government regulation of GHG emissions, mandated restrictions on the extraction and combustion of fossil fuels, and **other approaches are thereby marginalised**: they cannot – and, indeed, are not permitted to – compete. The **state** is not sidestepped per se but is instead **demoted**, its remit confined to the co-creation and ratification of schemes in which the bottom line is the top priority (Castree, 2011).” ([[Wright & Nyberg 2015]], p. 171)
- “The logic of this myth dictates that any action in response to climate change must first demonstrate a ‘**business** **case**’; moreover, any action that threatens profitability must be rejected.” ([[Wright & Nyberg 2015]], p. 171)

### Alternative narratives and imaginings

#### “Renewable reinvention”

- “the potential for a shift from fossil-fuel-based energy to the large-scale adoption of ‘renewables’.” ([[Wright & Nyberg 2015]], p. 173)
- “a vision that implies a positive future for humanity based on the market success of increasingly cheap and efficient solar, wind, and other renewable sources of energy.” ([[Wright & Nyberg 2015]], p. 173)
- **Problems**:
	 - “the **scale and speed of decarbonisation necessary** to avoid hazardous climate change is frequently ignored in optimistic interpretations of the future ‘green’ economy” ([[Wright & Nyberg 2015]], p. 174)
	 - “much of the advocacy for renewable energy **underestimates the political might of the fossil fuel industry** in resisting change.” ([[Wright & Nyberg 2015]], p. 174)
	 - “much of this narrative is folded within the wider political **myth of [[corporate environmentalism]]** ” ([[Wright & Nyberg 2015]], p. 174)
	 - _i.e. Renewable Reinvention does not address the fundamental instability of capitalism and endless economic growth_
 - “This most common and persuasive alternative narrative is post-political, in that the ‘problem’ of climate change can be handed over to technocratic management and consensual policymaking (Swyngedouw, 2010).” ([[Wright & Nyberg 2015]], p. 175)

#### “Regulatory and legal intervention”

- “State intervention has long been a stock response to market failure and corporate indulgence.” ([[Wright & Nyberg 2015]], p. 175)
- **Problems**:
	 - [[regulatory capture]] : “The ascendancy of **neoliberalism** as a political and economic doctrine since the 1970s has coincided with governments edging away from a focus on strict market regulation. Government has come to be regarded as impeding value creation and economic prosperity, and its role in economic management has therefore steadily drifted to the formulation of labour, product, and financial markets that facilitate profit maximisation. **Governments have become enmeshed within the interests of global capital,** with financially powerful corporations able to buy into the political apparatus through party lobbying and funding.” ([[Wright & Nyberg 2015]], p. 176)

#### “Steady-state economics and collapse” - [[degrowth]]

- “the ‘steady-state economy’ {…} is an economy that does not exceed ecological limits and has ‘stable (or mildly fluctuating) levels of population, consumption and therefore GDP’” ([[Wright & Nyberg 2015]], p. 178)
- “Pioneered by **ecological** **economists** such as **Herman Daly** (1977),” ([[Wright & Nyberg 2015]], p. 178)
- “Realising such a vision would involve **significant economic change**, of course, and advocates acknowledge that its implementation would necessitate the ‘de-growth’ of wealthy nations – which, needless to say, would be politically unpalatable.” ([[Wright & Nyberg 2015]], p. 179)
- **Problems**:
	 - **Unclear how to realize this political overhaul:** “Although based upon a noble goal, the advocacy of a steady-state economy is less clear on how such an agenda can be implemented, particularly in an era in which economic growth is seen as one of the most critical measures of political success.” ([[Wright & Nyberg 2015]], p. 179)
- “others say **collapse** of some kind is now **inevitable** and creative self-destruction will lead to a momentous correction of human folly. In this narrative it is already too late to evade punishment for our impudent belief that we can master nature: catastrophe is not only imminent but also inescapable.” ([[Wright & Nyberg 2015]], p. 180)

#### “Social mobilisation and divestment”

- “a far more grass-roots response to the climate crisis – one that is sprouting spontaneously from within local communities that are rising up and directly opposing the expansion of fossil fuel extraction.” ([[Wright & Nyberg 2015]], p. 180)
 - “Naomi Klein (2014: 293–336) has characterised this phenomena as ‘**Blockadia**’.” ([[Wright & Nyberg 2015]], p. 180)
- “Economically, an ever-louder chorus within the investment community has warned of the likelihood of a ‘**carbon bubble**’ and ‘**stranded assets**’ if governments hinder the continued exploitation of fossil fuels” ([[Wright & Nyberg 2015]], p. 182)
 - “one indication of the impact of this emergent political narrative has been the vehemence of the response from the fossil fuel industry itself.” ([[Wright & Nyberg 2015]], p. 183)
